/*
 * Steepest descent method
 *
 * Date: Oct 10, 2012
 * Author: Thomas Robey
 */
#include <stdlib.h>
#include <stdio.h>

int main(void) {
  int iter, maxiter;
  double x[2], z, g[2], gradient, alpha, resid;
  double fandg(double *, double*);

  x[0] = 5.0;
  x[1] = 7.0;
  iter = 1;
  resid = 1.0e-6;
  maxiter = 100;
  while (1) {
    z = fandg(x, g);
    printf("%d: %.15f %.15f %.15f\n", iter, x[0], x[1], z);
    //printf("Gradient: %.15f %.15f\n", g[0], g[1]);
    
    gradient = g[0]*g[0] + g[1]*g[1];
    if (gradient<resid*resid || iter>maxiter) {
      printf("Gradient: %.15f %.15f\n", g[0], g[1]);
      break;
    }

    // For this function the optimum step size can be computed analytically.
    alpha = (100.0*(x[0]-1.0)*(x[0]-1.0) + (x[1]-2.0)*(x[1]-2.0))/
            (2000.0*(x[0]-1.0)*(x[0]-1.0) + 2.0*(x[1]-2.0)*(x[1]-2.0));
    //printf("alpha: %.5f\n", alpha);
    x[0] = x[0] - 20.0*alpha*(x[0]-1.0);
    x[1] = x[1] - 2.0*alpha*(x[1]-2.0);

    iter++;
  }
  return 0;
}
